----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date: 07/24/2017 11:40:22 AM
-- Design Name: 
-- Module Name: clk_div - Behavioral
-- Project Name: 
-- Target Devices: 
-- Tool Versions: 
-- Description: 
-- 
-- Dependencies: 
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
-- 
----------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

Library UNISIM;
use UNISIM.vcomponents.all;


-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx leaf cells in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity clk_div is
    Port ( clk_out : out STD_LOGIC;
           clk_in : in STD_LOGIC;
           clk_en : in STD_LOGIC;
           clr : in STD_LOGIC);
end clk_div;

architecture Behavioral of clk_div is

begin

   -- BUFR: Regional Clock Buffer for I/O and Logic Resources within a Clock Region
   --       Artix-7
   -- Xilinx HDL Language Template, version 2017.2

   BUFR_inst : BUFR
   generic map (
      BUFR_DIVIDE => "2",   -- Values: "BYPASS, 1, 2, 3, 4, 5, 6, 7, 8" 
      SIM_DEVICE => "7SERIES"  -- Must be set to "7SERIES" 
   )
   port map (
      O => clk_out,     -- 1-bit output: Clock output port
      CE => clk_en,   -- 1-bit input: Active high, clock enable (Divided modes only)
      CLR => clr, -- 1-bit input: Active high, asynchronous clear (Divided modes only)
      I => clk_in      -- 1-bit input: Clock buffer input driven by an IBUF, MMCM or local interconnect
   );

   -- End of BUFR_inst instantiation
					
				
end Behavioral;
